
//scilab 5.5.2 , OS: Ubuntu 14.04
//Program To Design a simple notch filter and verify
// Design a simple notch filter to stop a disturbance with frequency F_0=3.5 kHz and a sampling frequency F_s=8 kHz.
//Also, verify the notch filter operation by adding a sinewave of F_0 Hz to a speech signal, filter and verify.

//Scilab Program: 
clc;clear;close;
f=3500;//input("Enter the frequency in Hz");             //3500
fs=8000;//input("Enter the sampling rate");              //8000
r=0.98;//input("Enter the radius of the pole in the z-plane"); //0.98
w=2*%pi*f/fs;
z1=exp(%i*w);
z2=exp(-%i*w);
p1=r*exp(%i*w);
p2=r*exp(-%i*w);
z=%z;
num1=(real((z-z1)*(z-z2)))
den1=(real(((z-p1)*(z-p2))))
Hz=num1./den1
//figure(1);plzr(Hz);zgrid()
[h1 fr]=frmag(Hz,512)
figure(1);plot2d(fr*fs,h1);xtitle('Magnitude response','frequency in Hz','Mag');

//Noise generation

original_signal=wavread('home/hyrkswamy/kswamy/Coursework/SAP/wav/mask.wav');
t=0:1/fs:(length(original_signal)-1)/fs;
noise=sin(2*%pi*f*t);
noisy_signal=original_signal+noise;

filter_output=filter(num1,den1,noisy_signal);

//Play back the original, noisy and filtered outputs
playsnd(original_signal,fs);
pause;
playsnd(noisy_signal,fs);
pause;
playsnd(filter_output,fs);




